% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatePCs.R
\name{plotPCcorrs}
\alias{plotPCcorrs}
\title{Plot significance of (cor)relations of covariates VS principal components}
\usage{
plotPCcorrs(pccorrs, pc = 1, logp = TRUE)
}
\arguments{
\item{pccorrs}{A \code{data.frame} object generated by \link{correlatePCs}}

\item{pc}{An integer number, corresponding to the principal component of
interest}

\item{logp}{Logical, defaults to \code{TRUE}, displays the -\code{log10} of
the pvalue instead of the p value itself}
}
\value{
A base plot object
}
\description{
Plots the significance of the (cor)relation of each covariate vs a principal component
}
\examples{
library(DESeq2)
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
rlt <- rlogTransformation(dds)
pcaobj <- prcomp(t(assay(rlt)))
res <- correlatePCs(pcaobj, colData(dds))
plotPCcorrs(res)

}
