% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPathwayDistances.R
\name{getPathwayDistances}
\alias{getPathwayDistances}
\title{Calculate pairwise distances from a table of pathways and genes}
\usage{
getPathwayDistances(pathwayData = sigoraDatabase, distMethod = "jaccard")
}
\arguments{
\item{pathwayData}{Three column data frame of pathways and their constituent
genes. Defaults to the provided \code{sigoraDatabase} object, but can be any set
of Reactome pathways. Must contain Ensembl gene IDs in the first column,
human Reactome pathway IDs in the second, and pathway descriptions in the
third.}

\item{distMethod}{Character; method used to determine pairwise pathway
distances. Can be any option supported by \code{vegan::vegdist()}.}
}
\value{
Matrix of the pairwise pathway distances (dissimilarity) based on
overlap of their constituent genes; object of class "matrix".
}
\description{
Given a data frame of pathways and their member genes, calculate
the pairwise distances using a constructed identity matrix. Zero means two
pathways are identical, while one means two pathways share no genes in
common.
}
\examples{
# Here we'll use a subset of all the pathways, to save time
data("sigoraDatabase")

getPathwayDistances(
    pathwayData=dplyr::slice_head(
        dplyr::arrange(sigoraDatabase, pathwayId),
        prop=0.05
    ),
    distMethod="jaccard"
)

}
\references{
None.
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
