% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{testMotif}
\alias{testMotif}
\title{Check motif}
\usage{
testMotif(x, motif, expr, ppi, mode = c("augment", "remove"),
  prop = 0.05, seed = 1, ...)
}
\arguments{
\item{x}{Model regulatory network.}

\item{motif}{Motif used to construct the model regulatory network.}

\item{expr}{Expression matrix used to construct model network.}

\item{ppi}{PPI used to construct model regulatory network.}

\item{mode}{a character string - either "augment" to add random edges or "remove" to remove random edges.}

\item{prop}{numeric specifying number of edges to augment or remove from regulatory prior, as a proportion of the number
of edges in the regulatory prior.}

\item{seed}{Random seed.}

\item{...}{Options for the panda function.}
}
\value{
ggplot heatmap list of indices of net corresponding to each TF
}
\description{
This function adds random false positive edges to the regulatory prior
and will check if they become pruned.
}
\examples{

data(pandaToyData)
data(pandaResult)
regnet = slot(pandaResult,"regNet")
with(pandaToyData, testMotif(regnet, motif, mode="augment", expression, ppi, hamming=1))

}
