% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBlastDb.R
\name{makeBlastDb}
\alias{makeBlastDb}
\title{Make Blast Database}
\usage{
makeBlastDb(fastaFile, dbPath, blastPath, dbType = "nucl")
}
\arguments{
\item{fastaFile}{FASTA file containing sequences to generate a BLAST 
database from.}

\item{dbPath}{Path to save the BLAST database to.}

\item{blastPath}{Path/name of BLAST program to use. Name of
the application for Linux/MacOS, absolute 
path for the executable for windows users.}

\item{dbType}{Type of BLAST database to create, e.g. "nucl"
for a nucleotide database.}
}
\value{
No return value; generates a blast database in 
the chosen directory.
}
\description{
Generates a BLAST database to be queried. Required 
for identifying sequences using the BLAST+ 
software.
}
\examples{
\dontrun{
makeBlastDb("genes.fasta", "blastdb.db", "C:/blast.exe")
}

}
\references{
For further information, see the NCBI BLAST+ application
documentation and help pages 
(https://www.ncbi.nlm.nih.gov/pubmed/20003500?dopt=Citation).
}
\seealso{
\code{\link{packSearch}}
}
\author{
Jack Gisby
}
