% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyPotentialPackElements.R
\name{identifyPotentialPackElements}
\alias{identifyPotentialPackElements}
\title{Pack Element Filtering}
\usage{
identifyPotentialPackElements(
  forwardMatches,
  reverseMatches,
  Genome,
  elementLength,
  tsdMismatch = 0
)
}
\arguments{
\item{forwardMatches}{A dataframe containing genomic ranges and names referring 
to forwards-facing TIR sequences and their respective 
TSD sequences.}

\item{reverseMatches}{A dataframe containing genomic ranges and names referring 
to reverse-facing TIR sequences and their respective 
TSD sequences.}

\item{Genome}{A DNAStringSet object containing the matches referred to 
in \code{forwardMatches} and \code{reverseMatches}}

\item{elementLength}{A vector of two integers containing the minimum and 
maximum transposable element length.}

\item{tsdMismatch}{An integer referring to the allowable mismatch 
(substitutions or indels) between a transposon's TSD
sequences. \code{\link[Biostrings]{matchPattern}} from Biostrings 
is used for pattern matching.}
}
\value{
A dataframe, \code{packMatches}, containing the locations 
of potential Pack-TYPE transposable elements in \code{Genome}.
}
\description{
Primary filtering stage for the \code{packSearch} 
algorithm. Identifies potential Pack-TYPE transposable 
elements based on proximity of matching inverted repeats 
and equality of TSD sequences.
}
\details{
Used by \code{\link{packSearch}} as a primariy filtering 
stage. Identifies matches likely to be transposons based 
on their TIR region, from \code{\link{identifyTirMatches}}, 
and their TSD region, from \code{\link{getTsds}}. It is 
recommended to use the general pipeline function 
\code{\link{packSearch}} for identification of potential 
pack elements, however each stage may be called 
individually. Note that only exact TSD matches are 
considered, so supplying long sequences for TSD elements 
may lead to false-negative results.
}
\examples{
data(arabidopsisThalianaRefseq)

forwardMatches <- identifyTirMatches(
    Biostrings::DNAString("CACTACAA"),
    arabidopsisThalianaRefseq,
    tsdLength = 3,
    strand = "+"
)

reverseMatches <- identifyTirMatches(
    Biostrings::reverseComplement(Biostrings::DNAString("CACTACAA")),
    arabidopsisThalianaRefseq,
    tsdLength = 3,
    strand = "-"
)

packMatches <- identifyPotentialPackElements(
    forwardMatches, 
    reverseMatches,
    arabidopsisThalianaRefseq, 
    c(300, 3500)
)

}
\seealso{
\code{packSearch}
}
\author{
Jack Gisby
}
