% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPacksFromCsv.R
\name{getPacksFromCsv}
\alias{getPacksFromCsv}
\title{Retrieve Saved packFinder Results (.csv)}
\usage{
getPacksFromCsv(file)
}
\arguments{
\item{file}{File path to predicted transposons in CSV format.}
}
\value{
Dataframe in the format used by \code{\link{packSearch}}.
}
\description{
Retrieves a dataframe of potential Pack-TYPE elements, 
previously saved using \code{\link{packSearch}} followed 
by \code{\link{packsToCsv}}.
}
\examples{
data(packMatches)

packMatches <- getPacksFromCsv(
    system.file("extdata", "packMatches.csv", package = "packFinder")
)

}
\seealso{
\code{\link{packsToCsv}}, \code{\link[utils]{read.table}}, 
\code{\link{packSearch}}
}
\author{
Jack Gisby
}
