% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{testMSnSet}
\alias{testMSnSet}
\title{Create a stratified 'test' \code{MSnSet}}
\usage{
testMSnSet(object, fcol = "markers", size = 0.2, seed)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}}

\item{fcol}{The feature meta-data column name containing the
marker definitions on which the data will be stratified. Default
is \code{markers}.}

\item{size}{The size of the data set to be extracted. Default is
0.2 (20 percent).}

\item{seed}{The optional random number generator seed.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} which
contains only the proteins that have a labelled localisation
i.e. the marker proteins, as defined in \code{fcol} and a new
column in the feature data slot called \code{test} which has part
of the labels relabelled as "unknown" class (the number of
proteins renamed as "unknown" is according to the parameter size).
}
\description{
This function creates a stratified 'test' \code{MSnSet} which can be used 
for algorihtmic development. A \code{"\linkS4class{MSnSet}"} containing only
the marker proteins, as defined in \code{fcol}, is returned with a new 
feature data column appended called \code{test} in which a stratified subset
of these markers has been relabelled as 'unknowns'.
}
\examples{
library(pRolocdata)
data(tan2009r1)
sample <- testMSnSet(tan2009r1)
getMarkers(sample, "test")
all(dim(sample) == dim(markerMSnSet(tan2009r1)))
}
\seealso{
\code{\link{sampleMSnSet}} \code{\link{unknownMSnSet}}
\code{\link{markerMSnSet}}
}
\author{
Lisa Breckels
}
