% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-framework-map.R,
%   R/machinelearning-functions-tagm-map.R
\docType{class}
\name{MAPParams-class}
\alias{MAPParams-class}
\alias{class:MAPParams}
\alias{MAPParams}
\alias{show,MAPParams-method}
\alias{logPosteriors}
\alias{tagmMapTrain}
\alias{tagmMapPredict}
\title{The `logPosteriors` function can be used to extract the log-posteriors at
each iteration of the EM algorithm to check for convergence.}
\usage{
\S4method{show}{MAPParams}(object)

logPosteriors(x)

tagmMapTrain(
  object,
  fcol = "markers",
  method = "MAP",
  numIter = 100,
  mu0 = NULL,
  lambda0 = 0.01,
  nu0 = NULL,
  S0 = NULL,
  beta0 = NULL,
  u = 2,
  v = 10,
  seed = NULL
)

tagmMapPredict(
  object,
  params,
  fcol = "markers",
  probJoint = FALSE,
  probOutlier = TRUE
)
}
\arguments{
\item{object}{An \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}} containing the spatial
proteomics data to be passed to \code{tagmMapTrain} and
\code{tagmPredict}.}

\item{x}{An object of class `MAPParams`.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{method}{A \code{charachter()} describing the inference method for
the TAGM algorithm. Default is \code{"MAP"}.}

\item{numIter}{The number of iterations of the
expectation-maximisation algorithm. Default is 100.}

\item{mu0}{The prior mean. Default is \code{colMeans} of the expression
data.}

\item{lambda0}{The prior shrinkage. Default is 0.01.}

\item{nu0}{The prior degreed of freedom. Default is
\code{ncol(exprs(object)) + 2}}

\item{S0}{The prior inverse-wishary scale matrix. Empirical prior
used by default.}

\item{beta0}{The prior Dirichlet distribution
concentration. Default is 1 for each class.}

\item{u}{The prior shape parameter for Beta(u, v). Default is 2}

\item{v}{The prior shape parameter for Beta(u, v). Default is 10.}

\item{seed}{The optional random number generator seed.}

\item{params}{An instance of class \code{\link{MAPParams}}, as generated by
\code{\link[=tagmMapTrain]{tagmMapTrain()}}.}

\item{probJoint}{A \code{logical(1)} indicating whether to return the
joint probability matrix, i.e. the probability for all classes
as a new \code{tagm.map.joint} feature variable.}

\item{probOutlier}{A \code{logical(1)} indicating whether to return the
probability of being an outlier as a new \code{tagm.map.outlier}
feature variable. A high value indicates that the protein is
unlikely to belong to any annotated class (and is hence
considered an outlier).}
}
\value{
\code{tagmMapTrain} returns an instance of class \code{\link[=MAPParams]{MAPParams()}}.

\code{tagmPredict} returns an instance of class
\code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}} containing the localisation predictions as
a new \code{tagm.map.allocation} feature variable.
}
\description{
These functions implement the T augmented Gaussian mixture (TAGM)
model for mass spectrometry-based spatial proteomics datasets
using the maximum a posteriori (MAP) optimisation routine.
}
\details{
The \code{tagmMapTrain} function generates the MAP parameters (object or class
\code{MAPParams}) based on an annotated quantitative spatial proteomics dataset
(object of class \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}}). Both are then passed to the
\code{tagmPredict} function to predict the sub-cellular localisation of protein
of unknown localisation. See the \emph{pRoloc-bayesian} vignette for details and
examples. In this implementation, if numerical instability is detected in
the covariance matrix of the data a small multiple of the identity is
added. A message is printed if this conditioning step is performed.
}
\section{Slots}{

\describe{
\item{\code{method}}{A \code{character()} storing the TAGM method name.}

\item{\code{priors}}{A \code{list()} with the priors for the parameters}

\item{\code{seed}}{An \code{integer()} with the random number generation seed.}

\item{\code{posteriors}}{A \code{list()} with the updated posterior parameters
and log-posterior of the model.}

\item{\code{datasize}}{A \code{list()} with details about size of data}
}}

\examples{
## Load example data
library(pRolocdata)
data(dunkley2006)

## Generate MAP parameters (use numIter = 5 for example only) 
par <- tagmMapTrain(dunkley2006, numIter = 5)

## Perform classification
dunkley2006 <- tagmMapPredict(dunkley2006,
                              params = par, 
                              probJoint = TRUE, 
                              probOutlier = TRUE)
}
\references{
\emph{A Bayesian Mixture Modelling Approach For Spatial
Proteomics} Oliver M Crook, Claire M Mulvey, Paul D. W. Kirk,
Kathryn S Lilley, Laurent Gatto bioRxiv 282269; doi:
https://doi.org/10.1101/282269
}
\seealso{
The \code{\link[=plotEllipse]{plotEllipse()}} function can be used to visualise
TAGM models on PCA plots with ellipses. The \code{\link[=tagmMapTrain]{tagmMapTrain()}}
function to use the TAGM MAP method.
}
\author{
Laurent Gatto

Oliver M. Crook
}
