% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{sampleMSnSet}
\alias{sampleMSnSet}
\title{Extract a stratified sample of an \code{MSnSet}}
\usage{
sampleMSnSet(object, fcol = "markers", size = 0.2, seed)
}
\arguments{
\item{object}{An instance of class \code{\linkS4class{MSnSet}}}

\item{fcol}{The feature meta-data column name containing the
marker (vector or matrix) definitions on which the MSnSet will be
stratified. Default is \code{markers}.}

\item{size}{The size of the stratified sample to be
extracted. Default is 0.2 (20 percent).}

\item{seed}{The optional random number generator seed.}
}
\value{
A stratified sample (according to the defined \code{fcol})
which is an instance of class \code{"\linkS4class{MSnSet}"}.
}
\description{
This function extracts a stratified sample of an \code{MSnSet}.
}
\examples{
library(pRolocdata)
data(tan2009r1)
dim(tan2009r1)
smp <- sampleMSnSet(tan2009r1, fcol = "markers")
dim(smp)
getMarkers(tan2009r1)
getMarkers(smp)
}
\seealso{
\code{\link{testMSnSet}} \code{\link{unknownMSnSet}}
\code{\link{markerMSnSet}}. See \code{\link{markers}} for details
about markers encoding.
}
\author{
Lisa Breckels
}
