% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-rf.R
\name{rfClassification}
\alias{rfClassification}
\alias{rfPrediction}
\title{rf classification}
\usage{
rfClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  mtry,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{rfOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{mtry}{If \code{assessRes} is missing, a \code{mtry} must be
provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to
\code{\link{randomForest}} from package \code{randomForest}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{rf} and \code{rf.scores} feature variables storing the
    classification results and scores respectively.
}
\description{
Classification using the random forest algorithm.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- rfOptimisation(dunkley2006, mtry = c(2, 5, 10),  times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- rfClassification(dunkley2006, params)
getPredictions(res, fcol = "rf")
getPredictions(res, fcol = "rf", t = 0.75)
plot2D(res, fcol = "rf")
}
\author{
Laurent Gatto
}
