% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-PerTurbo.R
\name{perTurboOptimisation}
\alias{perTurboOptimisation}
\alias{perTurboOptimization}
\title{PerTurbo parameter optimisation}
\usage{
perTurboOptimisation(
  object,
  fcol = "markers",
  pRegul = 10^(seq(from = -1, to = 0, by = 0.2)),
  sigma = 10^(seq(from = -1, to = 1, by = 0.5)),
  inv = c("Inversion Cholesky", "Moore Penrose", "solve", "svd"),
  reg = c("tikhonov", "none", "trunc"),
  times = 1,
  test.size = 0.2,
  xval = 5,
  fun = mean,
  seed,
  verbose = TRUE
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{pRegul}{The hyper-parameter for the regularisation (values are in ]0,1] ).
If reg =="trunc", pRegul is for the percentage of eigen values in matrix.
If reg =="tikhonov", then 'pRegul' is the parameter for the tikhonov regularisation.
Available configurations are :
"Inversion Cholesky" - ("tikhonov" / "none"),
"Moore Penrose" - ("tikhonov" / "none"),
"solve" - ("tikhonov" / "none"),
"svd" - ("tikhonov" / "none" / "trunc").}

\item{sigma}{The hyper-parameter.}

\item{inv}{The type of algorithm used to invert the matrix.
Values are :
"Inversion Cholesky" (\code{\link{chol2inv}}),
"Moore Penrose" (\code{\link{ginv}}),
"solve" (\code{\link{solve}}),
"svd" (\code{\link{svd}}).
Default value is \code{"Inversion Cholesky"}.}

\item{reg}{The type of regularisation of matrix.
Values are "none", "trunc" or "tikhonov".
Default value is \code{"tikhonov"}.}

\item{times}{The number of times internal cross-validation is performed.
Default is 100.}

\item{test.size}{The size of test data. Default is 0.2 (20 percent).}

\item{xval}{The \code{n}-cross validation. Default is 5.}

\item{fun}{The function used to summarise the \code{times} macro F1 matrices.}

\item{seed}{The optional random number generator seed.}

\item{verbose}{A \code{logical} defining whether a progress bar is displayed.}
}
\value{
An instance of class \code{"\linkS4class{GenRegRes}"}.
}
\description{
Classification parameter optimisation for the PerTurbo algorithm
}
\details{
Note that when performance scores precision, recall and (macro) F1
are calculated, any NA values are replaced by 0. This decision is
motivated by the fact that any class that would have either a NA
precision or recall would result in an NA F1 score and,
eventually, a NA macro F1 (i.e. mean(F1)). Replacing NAs by 0s
leads to F1 values of 0 and a reduced yet defined final macro F1
score.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space 
params <- perTurboOptimisation(dunkley2006,
                               pRegul = 2^seq(-2,2,2),
                               sigma = 10^seq(-1, 1, 1),
                               inv = "Inversion Cholesky",
                               reg ="tikhonov",
                               times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- perTurboClassification(dunkley2006, params)
getPredictions(res, fcol = "perTurbo")
getPredictions(res, fcol = "perTurbo", t = 0.75)
plot2D(res, fcol = "perTurbo")
}
\seealso{
\code{\link{perTurboClassification}} and example therein.
}
\author{
Thomas Burger and Samuel Wieczorek
}
