% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-nb.R
\name{nbOptimisation}
\alias{nbOptimisation}
\alias{nbRegularisation}
\alias{nbOptimization}
\title{nb paramter optimisation}
\usage{
nbOptimisation(
  object,
  fcol = "markers",
  laplace = seq(0, 5, 0.5),
  times = 100,
  test.size = 0.2,
  xval = 5,
  fun = mean,
  seed,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{laplace}{The hyper-parameter. Default values are \code{seq(0, 5, 0.5)}.}

\item{times}{The number of times internal cross-validation is performed.
Default is 100.}

\item{test.size}{The size of test data. Default is 0.2 (20 percent).}

\item{xval}{The \code{n}-cross validation. Default is 5.}

\item{fun}{The function used to summarise the \code{xval} macro F1 matrices.}

\item{seed}{The optional random number generator seed.}

\item{verbose}{A \code{logical} defining whether a progress bar is displayed.}

\item{...}{Additional parameters passed to \code{\link{naiveBayes}} from package \code{e1071}.}
}
\value{
An instance of class \code{"\linkS4class{GenRegRes}"}.
}
\description{
Classification algorithm parameter for the naive Bayes algorithm.
}
\details{
Note that when performance scores precision, recall and (macro) F1
are calculated, any NA values are replaced by 0. This decision is
motivated by the fact that any class that would have either a NA
precision or recall would result in an NA F1 score and,
eventually, a NA macro F1 (i.e. mean(F1)). Replacing NAs by 0s
leads to F1 values of 0 and a reduced yet defined final macro F1
score.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- nbOptimisation(dunkley2006, laplace = c(0, 5),  times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- nbClassification(dunkley2006, params)
getPredictions(res, fcol = "naiveBayes")
getPredictions(res, fcol = "naiveBayes", t = 1)
plot2D(res, fcol = "naiveBayes")
}
\seealso{
\code{\link{nbClassification}} and example therein.
}
\author{
Laurent Gatto
}
