% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-nb.R
\name{nbClassification}
\alias{nbClassification}
\alias{nbPrediction}
\title{nb classification}
\usage{
nbClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  laplace,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{nbOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{laplace}{If \code{assessRes} is missing, a \code{laplace}
must be provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to
\code{\link{naiveBayes}} from package \code{e1071}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{nb} and \code{nb.scores} feature variables storing the
    classification results and scores respectively.
}
\description{
Classification using the naive Bayes algorithm.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- nbOptimisation(dunkley2006, laplace = c(0, 5),  times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- nbClassification(dunkley2006, params)
getPredictions(res, fcol = "naiveBayes")
getPredictions(res, fcol = "naiveBayes", t = 1)
plot2D(res, fcol = "naiveBayes")
}
\author{
Laurent Gatto
}
