% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{getMarkerClasses}
\alias{getMarkerClasses}
\title{Returns the organelle classes in an 'MSnSet'}
\usage{
getMarkerClasses(object, fcol = "markers", ...)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The name of the markers column in the \code{featureData}
slot. Default is \code{markers}.}

\item{...}{Additional parameters passed to \code{sort} from the base package.}
}
\value{
A \code{character} vector of the organelle classes in the data.
}
\description{
Convenience accessor to the organelle classes in an 'MSnSet'.
This function returns the organelle classes of an
\code{MSnSet} instance. As a side effect, it prints out the classes.
}
\examples{
library("pRolocdata")
data(dunkley2006)
organelles <- getMarkerClasses(dunkley2006)
## same if markers encoded as a matrix
dunkley2006 <- mrkVecToMat(dunkley2006, mfcol = "Markers")
organelles2 <- getMarkerClasses(dunkley2006, fcol = "Markers")
stopifnot(all.equal(organelles, organelles2))
}
\seealso{
\code{\link{getMarkers}} to extract the marker
proteins. See \code{\link{markers}} for details about spatial
markers storage and encoding.
}
\author{
Lisa Breckels and Laurent Gatto
}
