% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goannotations.R
\name{filterMaxMarkers}
\alias{filterMaxMarkers}
\title{Removes class/annotation information from a matrix of candidate
markers that appear in the \code{fData}.}
\usage{
filterMaxMarkers(object, n, p = 0.2, fcol = "GOAnnotations", verbose = TRUE)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{n}{Maximum number of proteins allowed per class/information
term.}

\item{p}{Maximum percentage of proteins per column. Default is 0.2 
i.e. remove columns that have information for greater than 20% 
of the total number of proteins in the dataset (note: this is useful
for example, if information is GO terms, for removing very general
and uninformative terms).}

\item{fcol}{The name of the matrix of marker information. Default is
\code{GOAnnotations}.}

\item{verbose}{Number of marker candidates retained after filtering.}
}
\value{
An updated \code{MSnSet}
}
\description{
Removes annotation information that contain more that a
certain number/percentage of proteins
}
\seealso{
\code{filterMinMarkers} and example therein.
}
