% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkFeatureNamesOverlap}
\alias{checkFeatureNamesOverlap}
\title{Check feature names overlap}
\usage{
checkFeatureNamesOverlap(x, y, fcolx = "markers", fcoly, verbose = TRUE)
}
\arguments{
\item{x}{An \code{MSnSet} instance.}

\item{y}{An \code{MSnSet} instance.}

\item{fcolx}{The feature variable to separate unknown
(\code{fData(y)$coly == "unknown"}) from the marker features in
the \code{x} object.}

\item{fcoly}{As \code{fcolx}, for the \code{y} object. If missing,
the value of \code{fcolx} is used.}

\item{verbose}{If \code{TRUE} (default), the overlap is printed
out on the console.}
}
\value{
Invisibly returns a named list of common markers, unique
\code{x} markers, unique \code{y} markers in, common unknowns,
unique \code{x} unknowns and unique \code{y} unknowns.
}
\description{
Checks the marker and unknown feature overlap of two \code{MSnSet}
instances.
}
\examples{
library("pRolocdata")
data(andy2011)
data(andy2011goCC)
checkFeatureNamesOverlap(andy2011, andy2011goCC)
featureNames(andy2011goCC)[1] <- "ABC"
res <- checkFeatureNamesOverlap(andy2011, andy2011goCC)
res$markersX
res$markersY
}
\author{
Laurent Gatto
}
