% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1Score.R
\name{f1Score}
\alias{f1Score}
\title{f1Score}
\usage{
f1Score(clustering, cytometry, noise.cells)
}
\arguments{
\item{clustering}{The labels of the new classification.}

\item{cytometry}{Data of the clustering, where the last variable contains the original labels.}

\item{noise.cells}{An array of labels to be considered as noise.}
}
\value{
A matrix where the first row is the F1 score, the second row is the Precision and the third row is the Recall.
}
\description{
Calculates the F1 score fore each group in a partition.
}
\examples{
f1Score(dplyr::pull(Cytometry3[c(sample(1:250,250),251:(dim(Cytometry3)[1])),],11),
        Cytometry3, noise.types)

}
\references{
E del Barrio, H Inouzhe, JM Loubes, C Matran and A Mayo-Iscar. (2019) optimalFlow: Optimal-transport approach to flow cytometry gating and population matching. arXiv:1907.08006
}
