% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationCellBarycenter.R
\name{estimationCellBarycenter}
\alias{estimationCellBarycenter}
\title{estimationCellBarycenter}
\usage{
estimationCellBarycenter(cell, cytometries)
}
\arguments{
\item{cell}{Name of the cluster of interest.}

\item{cytometries}{List of clusterings.}
}
\value{
A list representing the (1-)barycenter:
\describe{
 \item{mean}{Mean of the barycenter.}
 \item{cov}{Covariance of the barycenter.}
 \item{weight}{Weight associated to the barycenter.}
 \item{type}{Type of the cluster.}
}
}
\description{
Estimates a Wasserstein barycenter for a cluster type using a collection of partitions.
}
\examples{
partition1 <- list(list(mean = c(1, 1), cov = diag(1, 2), weight = 0.5, type = '1'),
                  list(mean = c(-1, -1), cov = diag(1, 2), weight = 0.5, type = '2'))
partition2 <- list(list(mean = c(1, -1), cov = diag(1, 2), weight = 0.5, type = '1'),
                  list(mean = c(-1, 1), cov = diag(1, 2), weight = 0.5, type = '2'))
cytometries <- list(partition1, partition2)
estimationCellBarycenter('1',cytometries)

}
