% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubtypeProbes.R
\docType{methods}
\name{getSubtypeProbes}
\alias{getSubtypeProbes}
\alias{getSubtypeProbes,OPPARList,nuchar-method}
\alias{getSubtypeProbes,matrix,nuchar-method}
\title{Retrieving outlier genes from a group of related samples}
\usage{
getSubtypeProbes(profileMatrix, sample.names)

\S4method{getSubtypeProbes}{matrix,nuchar}(profileMatrix, sample.names)

\S4method{getSubtypeProbes}{OPPARList,nuchar}(profileMatrix, sample.names)
}
\arguments{
\item{profileMatrix}{A matrix of 0,1 and -1, representing outlier genes in samples.
Also an object of type \code{OPPARList}.}

\item{sample.names}{A character vector containing sample names, or a numeric vector
containing the indices of the samples.}
}
\value{
A list of lists. The sub-lists are up-regulated outlier genes, and down-regulated outlier genes.
}
\description{
Returns a list of genes that are outlier in a group of samples, such as samples from the same subtype.
}
\section{Methods (by class)}{
\itemize{
\item \code{profileMatrix = matrix,sample.names = nuchar}: A method for getSubtypeProbes with signature profileMatrix = \code{matrix}
and sample.names = \code{nuchar}

\item \code{profileMatrix = OPPARList,sample.names = nuchar}: A method for getSubtypeProbes with signature profileMatrix = \code{OPPARList}
and sample.names = \code{nuchar}
}}
\examples{
data(GSE46141)
library(Biobase)
group <- sapply(pData(bcm)$source_name_ch1, function(x){ ifelse(x == "breast",0,1)})
group <- factor(group)
bcm.opa <- opa(bcm,group=group)
# extracting liver samples
index <- which(pData(bcm)$source_name_ch1 == "liver")
samples <- rownames(pData(bcm)[index,])
samples <- match(samples, colnames(bcm.opa$profileMatrix))
samples <- Reduce(c,samples)
# liver subtype outlier profile
liver.subtype.outlier <- getSubtypeProbes(bcm.opa, samples)
}

