% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_ILP.R
\name{solve.ILP}
\alias{solve.ILP}
\title{Solve an ILP}
\usage{
\method{solve}{ILP}(
  cur.D,
  cur.G,
  cur.settings,
  cur.cvg.matrix,
  time.limit,
  required.cvg,
  primer.df,
  template.df
)
}
\arguments{
\item{cur.D}{Binary dimerization matrix.}

\item{cur.G}{Free energy matrix for cross-dimerization.}

\item{cur.settings}{Current \code{DesignSettings} object.}

\item{cur.cvg.matrix}{Binary coverage matrix.}

\item{time.limit}{Time limit for solving the ILP in seconds.}

\item{required.cvg}{The target coverage of the designed primer set.}

\item{primer.df}{A \code{Primers} object.}

\item{template.df}{A \code{Templates} object.}

\item{deltaG.cutoff}{Cutoff for dimerization free energy.}

\item{deltaG.limit}{Relaxation limit for free energy cutoff.}
}
\value{
List with ILP solution data.
}
\description{
Constructs and solves an ILP and outputs a list with the reuslts.
}
\keyword{internal}
