% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_primers.R
\name{initialize.primer.set}
\alias{initialize.primer.set}
\title{Creation of Initial Primers}
\usage{
initialize.primer.set(
  template.df,
  sample.name,
  primer.lengths,
  allowed.region.definition,
  mode.directionality,
  init.algo,
  max.degen,
  conservation,
  cur.results.loc
)
}
\arguments{
\item{template.df}{Template data frame.}

\item{sample.name}{Name of the template sample.}

\item{primer.lengths}{Interval of minimal and maximal desired primer length.}

\item{allowed.region.definition}{Definition of the allowed binding region.}

\item{mode.directionality}{Direction of primers to be created.}

\item{init.algo}{Algorithm for initializing primers.}

\item{max.degen}{Maximal allowed degeneration of created primers.}

\item{conservation}{Required conservation of primers.
The value of \code{conservation} should be in the range[0,1].}

\item{cur.results.loc}{Location for writing the primers as csv.}
}
\value{
An initial primer data frame.
}
\description{
Creates a set of candidate primers.
}
\keyword{internal}
