% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_coverage.R
\name{get_plot_primer_data}
\alias{get_plot_primer_data}
\title{Data for Primer Plot.}
\usage{
get_plot_primer_data(
  primer.df,
  template.df,
  identifier = NULL,
  relation = c("fw", "rev")
)
}
\arguments{
\item{primer.df}{An object of class \code{Primers} containing
primers with evaluated primer coverage.}

\item{template.df}{An object of class \code{Templates} with template sequences
corresponding to \code{primer.df}.}

\item{identifier}{Identifiers of primers that are to be considered.
If \code{identifier} is set to \code{NULL} (the default), all primers are considered.}

\item{relation}{Compute binding positions relative to forward (\code{fw}) or reverse (\code{rev}) binding regions.
The default is "fw".}
}
\value{
Data frame with primer binding data.
}
\description{
Constructs a data frame containing information
about primer binding events.
}
\keyword{internal}
