% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_coverage.R
\name{get.duplex.energies}
\alias{get.duplex.energies}
\title{Determination of the Free Binding Energy.}
\usage{
get.duplex.energies(
  primer.df,
  template.df,
  annealing.temp,
  settings,
  mode = c("on_target", "off_target")
)
}
\arguments{
\item{primer.df}{A \code{Primers} object.}

\item{template.df}{A \code{Templates} object.}

\item{annealing.temp}{The vector of optimal annealing temperatures of the primers.}

\item{settings}{A \code{DesignSettings} object.}

\item{mode}{If the \code{mode} is set to "on_target", 
the free energies of binding events in the allowed region are computed, while if the \code{mode} is set to
"off_target", the free energies of off-target events are computed.}
}
\value{
A list of lists containing the numeric free energies of the annealing events for every primer.
}
\description{
Computest the free energy of annealing between primers and templates. If the \code{mode} is set to "on_target", 
the free energies of binding events in the allowed region are computed, while if the \code{mode} is set to
"off_target", the free energies of off-target events are computed.
}
\keyword{internal}
