% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_coverage.R
\name{evaluate.basic.cvg}
\alias{evaluate.basic.cvg}
\title{Evaluation of Primer Coverage.}
\usage{
evaluate.basic.cvg(
  template.df,
  primers,
  mode.directionality = c("fw", "rev", "both"),
  allowed.mismatches,
  allowed.other.binding.ratio,
  allowed.region.definition = c("within", "any"),
  updateProgress = NULL
)
}
\arguments{
\item{template.df}{Template data frame.}

\item{primers}{Primer data frame.}

\item{mode.directionality}{Primer directionality.}

\item{allowed.mismatches}{The number of allowed mismatches per binding event.}

\item{allowed.other.binding.ratio}{Ratio of primers that are allowed to bind to non-allowed regions.
If \code{allowed.other.binding.ratio} >0 primers are allowed to bind at any location within the templates.
However, a warning is given if the ratio of primers binding to non-target regions exceeds the \code{allowed.other.binding.ratio}.}

\item{allowed.region.definition}{Definition of the target binding sites used for evaluating the coverage.
If \code{allowed.region.definition} is \code{within}, primers have to lie within the allowed binding region.
If \code{allowed.region.definition} is \code{any}, primers have to overlap with the allowed binding region.
The default is that primers have to bind within the target binding region.}

\item{updateProgress}{Progress callback function for shiny.}
}
\value{
Primer data frame with information on the covered template sequences.
}
\description{
Evaluates the coverage of a set of primers.
}
\keyword{internal}
