% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_primers.R
\name{create.primers.naive}
\alias{create.primers.naive}
\title{Naive Initialization of Primers.}
\usage{
create.primers.naive(
  seqs,
  seq.IDs,
  seq.groups,
  l.s,
  e.s,
  primer.lengths,
  allowed.region.definition,
  max.degen,
  sample = "",
  identifier = "",
  updateProgress = NULL
)
}
\arguments{
\item{seqs}{The template sequence strings.}

\item{seq.IDs}{The identifiers of the templates.}

\item{seq.groups}{The group identifiers of the templates.}

\item{l.s}{The positions where the allowed region starts for each template.}

\item{e.s}{The positions where the allowed reigon ends for each template.}

\item{primer.lengths}{Vector of desired primer lengths.}

\item{allowed.region.definition}{Definition of the allowed region.}

\item{max.degen}{Maximum allowed degeneracy of primers.}

\item{sample}{Template sample identifier.}

\item{updatProgress}{Shiny progress object.}
}
\value{
Data frame with initialized primer candidates.
}
\description{
Initialize primers by extracting substrings from all templates.
}
\keyword{internal}
