% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_eval.R
\name{check_constraints_comparison}
\alias{check_constraints_comparison}
\title{Batch Procedure for Evaluating Primer Sets.}
\usage{
check_constraints_comparison(
  primer.data,
  template.data,
  settings,
  active.constraints = names(constraints(settings)),
  to.compute.constraints = active.constraints,
  for.shiny = FALSE,
  updateProgress = NULL
)
}
\arguments{
\item{primer.data}{A list of objects of class \code{Primers}.}

\item{template.data}{A list of objects of class \code{Templates}
corresponding to \code{primer.data}.}

\item{settings}{An object of class \code{DesignSettings}.}

\item{active.constraints}{A character vector providing identifiers
of constraints to be considered.}

\item{to.compute.constraints}{A character vector providing identifiers
of constraints to be computed.}

\item{for.shiny}{A logical indicating whether the results are
indicated for the Shiny app or not.}

\item{updateProgress}{A callback function to track progress in the Shiny app.}
}
\value{
A list with objects of class \code{Primers}.
}
\description{
Batch Procedure for Evaluating Primer Sets.
}
\examples{
\dontrun{
data(Comparison)
eval.data <- check_constraints_comparison(primer.data[1:2], template.data[1:2], settings)
}
}
\keyword{internal}
