% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{augment.primer.cvg}
\alias{augment.primer.cvg}
\title{Augmentation of Primer Coverage.}
\usage{
augment.primer.cvg(
  primer.df,
  template.df,
  settings,
  partial = FALSE,
  constraint = NULL
)
}
\arguments{
\item{primer.df}{A \code{Primers} object for which
the primer coverage shall be augmented.}

\item{template.df}{A \code{Templates} object.}

\item{settings}{A \code{DesignSettings} object giving
the parameters for coverage computations.}

\item{partial}{Whether all missing primer coverage values should be 
computed. If \code{partial} is \code{TRUE}, only 
the coverage values of the primers that were excluded due to
the specified \code{constraint} are computed.}

\item{constraint}{A character vector specifying the exclusion
reason for which the partial augmentation should take place.}
}
\value{
A \code{Primers} object with augmented coverage entries.
}
\description{
Computes the coverage for the primers in \code{primer.df} 
that is still missing such that the relaxation procedure can adjust
appropriate constraints.
}
\keyword{internal}
