% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoMix_two_component_mixture_models.R
\name{topGeneQuants}
\alias{topGeneQuants}
\title{Identify genes that meet pre-specified quantiles}
\usage{
topGeneQuants(mmParams, deltMu2Thr = 90, deltMu1Thr = 10, siThr = 0.99)
}
\arguments{
\item{mmParams}{The output from the mixModelParams function.}

\item{deltMu2Thr}{The percentile threshold for the deltaMu2 statistic.
All genes exceeding this percentile threshold will be selected.}

\item{deltMu1Thr}{The percentile threshold for the deltaMu1 statistic.
All genes exceeding this percentile threshold will be selected.}

\item{siThr}{The threshold for the selectivity index statistic
(between 0-1). All genes exceeding this threshold will be selected.}
}
\value{
Returns a dataframe containing all genes meeting the prespecified
thresholds.
}
\description{
This function allows you to subset genes that are above pre-specified
quantiles and that most closely resemble the distribution of oncogenes.
}
\examples{
exprNml <- as.data.frame(matrix(data=rgamma(n=150, shape=2, rate=2),
nrow=10, ncol=15))
colnames(exprNml) <- paste0("patientN", seq_len(ncol(exprNml)))
rownames(exprNml) <- paste0("gene", seq_len(nrow(exprNml)))

exprTum <- as.data.frame(matrix(data=rgamma(n=150, shape=4, rate=3),
nrow=10, ncol=15))
colnames(exprTum) <- paste0("patientT", seq_len(ncol(exprTum)))
rownames(exprTum) <- paste0("gene", seq_len(nrow(exprTum)))

mmParams <- mixModelParams(exprNml, exprTum)
topGeneQuants(mmParams)
}
\seealso{
\code{\link{mixModelParams}}
}
\keyword{subsetting}
