% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{normalizeColWise}
\alias{normalizeColWise}
\title{Column-wise normalization of expression matrix}
\usage{
normalizeColWise(
  x,
  method = c("Median centering", "Median centering (shared ID)", "Total sum",
    "median centering + variance stablization")[1]
)
}
\arguments{
\item{x}{an expression matrix where rows are features and columns are samples, usually log transformed.}

\item{method}{normalization method to use
"Median centering" - median centering, see \code{\link{normalize.nQuantiles}}
"Median centering (shared ID)" - median centering using shared features, see \code{\link{normalize.nQuantiles}}
"Total sum" - total sum normalization
"median centering + variance stablization" - 10 quantile normalization using 0.25, 0.3, ..., 0.75, 
see \code{\link{normalize.nQuantiles}}}
}
\value{
a normalized matrix
}
\description{
A wrapper function of all column-wise normalization methods
}
\examples{
e1 <- matrix(rnorm(5000), 100, 50)+10
boxplot(e1)
e2 <- normalizeColWise(x = e1, method = "Median centering")
boxplot(e2)

}
