% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{extendMetaData}
\alias{extendMetaData}
\alias{extendMetaData,ExpressionSet,data.frame-method}
\alias{extendMetaData,SummarizedExperiment,data.frame-method}
\alias{extendMetaData,SummarizedExperiment,DFrame-method}
\title{Add extra columns to the phenoData/colData or featureData/rowData in ExpressionSet/SummarizedExperiment}
\usage{
extendMetaData(object, newData, where)

\S4method{extendMetaData}{ExpressionSet,data.frame}(
  object,
  newData,
  where = c("pData", "fData", "colData", "rowData")[1]
)

\S4method{extendMetaData}{SummarizedExperiment,data.frame}(
  object,
  newData,
  where = c("pData", "fData", "colData", "rowData")[1]
)

\S4method{extendMetaData}{SummarizedExperiment,DFrame}(
  object,
  newData,
  where = c("pData", "fData", "colData", "rowData")[1]
)
}
\arguments{
\item{object}{an object of \code{ExpressionSet-class}}

\item{newData}{a \code{data.frame} containing the data to be added}

\item{where}{where to add the extra columns, 
should be one of "pData", "fData", "rowData" and "colData".}
}
\value{
an object of \code{ExpressionSet-class}
}
\description{
Add extra columns to the phenoData/colData or featureData/rowData in ExpressionSet/SummarizedExperiment

Add extra columns to the phenoData/colData or featureData/rowData in ExpressionSet/SummarizedExperiment

Add extra columns to the phenoData/colData or featureData/rowData in ExpressionSet/SummarizedExperiment
}
\note{
The attributes in the pheno data and feature data will be preserved
}
\examples{
est <- Biobase::ExpressionSet(assayData=matrix(runif(1000), nrow=100, ncol=10))
Biobase::pData(est)
est <- extendMetaData(est, data.frame(letter = letters[1:10]), where = "pData")
Biobase::pData(est)
}
