% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_databaseFormat.R
\name{saveOmicsViewerDb}
\alias{saveOmicsViewerDb}
\alias{saveOmicsViewerDb,SummarizedExperiment,character-method}
\alias{saveOmicsViewerDb,ExpressionSet,character-method}
\title{Save the xcmsViewer result object as sqlite database}
\usage{
saveOmicsViewerDb(obj, db.file, overwrite = TRUE)

\S4method{saveOmicsViewerDb}{SummarizedExperiment,character}(obj, db.file, overwrite = TRUE)

\S4method{saveOmicsViewerDb}{ExpressionSet,character}(obj, db.file, overwrite = TRUE)
}
\arguments{
\item{obj}{an object of class ExpressionSet or SummarizedExperiment}

\item{db.file}{a character indicate file name of the database file}

\item{overwrite}{logical. whether the database should be overwritten if exist already.}
}
\value{
the directory where the database saved
}
\description{
Save the xcmsViewer result object as sqlite database
}
\examples{
f <- system.file("extdata", "demo.RDS", package = "omicsViewer")
es <- readRDS(f)
# The following line will write a database file on your disk
# saveOmicsViewerDb(es, db.file = "./omicsViewerData.db")
}
