% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Matched-class}
\alias{Matched-class}
\alias{Matched}
\title{Matched objects}
\description{
The Matched class is a container for attributes of covariate-matched
data resulting from \code{matchRanges()}.
}
\section{Slots}{

\describe{
\item{\code{matchedData}}{A \code{data.table} with matched data}

\item{\code{matchedIndex}}{An integer vector corresponding
to the indices in the \code{pool} which comprise the
\code{matched} set.}

\item{\code{covar}}{A character vector describing the covariates
used for matching.}

\item{\code{method}}{Character describing replacement method
used for matching.}

\item{\code{replace}}{TRUE/FALSE describing if matching was
done with or without replacement.}
}}

\section{Accessor methods for Matched Class}{

Functions that get data from Matched subclasses (\code{x})
such as MatchedDataFrame, MatchedGRanges,
and MatchedGInteractions are listed below:
\itemize{
\item \code{matchedData(x)}: Get matched data from a Matched object
\item \code{covariates(x)}: Get covariates from a Matched object
\item \code{method(x)}: Get matching method used for Matched object
\item \code{withReplacement(x)}: Get replace method
\item \code{indices(x, set)}: Get indices of matched set
}
For more detail check the help pages for these functions.
}

\examples{
## Make Matched example
set.seed(123)
x <- makeExampleMatchedDataSet(matched = TRUE)
## Accessor functions for Matched class
matchedData(x)
covariates(x)
method(x)
withReplacement(x)
head(indices(x, set = 'matched'))

}
\seealso{
\link{matchedData}, \link{covariates}, \link{method},
\link{withReplacement}, \link{indices}
}
