% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{pqn_normalization}
\alias{pqn_normalization}
\title{Probabilistic quotient normalization}
\usage{
pqn_normalization(
  object,
  ref = c("qc", "all"),
  method = c("median", "mean"),
  all_features = FALSE,
  assay.type = NULL,
  name = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{ref}{character, the type of reference samples to use for normalization.}

\item{method}{character, the method to use for calculating the reference 
sample.}

\item{all_features}{logical, should all features be used for calculating the 
reference sample?}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{name}{character, name of the resultant assay in case of multiple assays}
}
\value{
A SummarizedExperiment object with altered feature 
abundances.
}
\description{
Apply probabilistic quotient normalization (PQN) to the peak table of a 
SummarizedExperiment object. By default, reference is 
calculated from high-quality QC samples and the median of the reference is 
used for normalization. Check parameters for more options.
}
\examples{
data(toy_notame_set)
pqn_set <- pqn_normalization(toy_notame_set)

}
