% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{plot_dist_density}
\alias{plot_dist_density}
\title{Plot distance density}
\usage{
plot_dist_density(
  object,
  all_features = FALSE,
  dist_method = "euclidean",
  center = TRUE,
  scale = "uv",
  color_scale = getOption("notame.color_scale_dis"),
  fill_scale = getOption("notame.fill_scale_dis"),
  title = paste("Density plot of", dist_method, "distances between samples"),
  subtitle = NULL,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? 
If FALSE (the default), flagged features are removed before visualization.}

\item{dist_method}{method for calculating the distances, passed to 
\code{\link[stats]{dist}}}

\item{center}{logical, should the data be centered?}

\item{scale}{scaling used, as in \code{\link[pcaMethods]{prep}} 
Default is "uv" for unit variance}

\item{color_scale}{a scale for the color of the edge of density curves, as 
returned by a ggplot function}

\item{fill_scale}{a scale for the fill of the density curves, as returned by 
a ggplot function}

\item{title}{the plot title}

\item{subtitle}{the plot subtitle}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A ggplot object.
}
\description{
Plot density of distances between samples in QC samples and actual samples.
}
\examples{
data(toy_notame_set, package = "notame")
plot_dist_density(toy_notame_set)
# Drift correction tightens QCs together
plot_dist_density(notame::correct_drift(toy_notame_set))

}
\seealso{
\code{\link[stats]{dist}}
}
