% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKmers.R
\docType{methods}
\name{plotKmers}
\alias{plotKmers}
\alias{plotKmers,ANY-method}
\alias{plotKmers,FastqcData-method}
\alias{plotKmers,FastqcDataList-method}
\alias{plotKmers,FastpData-method}
\title{Plot Overrepresented Kmers}
\usage{
plotKmers(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotKmers}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotKmers}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  n = 6,
  linewidth = 0.5,
  plotlyLegend = FALSE,
  scaleColour = NULL,
  pal = c("red", "blue", "green", "black", "magenta", "yellow"),
  ...
)

\S4method{plotKmers}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  cluster = FALSE,
  dendrogram = FALSE,
  pwfCols,
  showPwf = TRUE,
  scaleFill = NULL,
  heatCol = hcl.colors(50, "inferno"),
  heat_w = 8,
  ...
)

\S4method{plotKmers}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  module = c("Before_filtering", "After_filtering"),
  reads = c("read1", "read2"),
  readsBy = c("facet", "mean", "diff"),
  trans = "log2",
  scaleFill = NULL,
  plotTheme = theme_get(),
  plotlyLegend = FALSE,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file paths}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{regex to drop from the end of filenames}

\item{...}{Used to pass parameters to theme for FastqcData objects and to
geoms for FastpData objects}

\item{n}{\code{numeric}. The number of Kmers to show.}

\item{linewidth}{Passed to \code{geom_line()}}

\item{plotlyLegend}{Show legend for interactive plots}

\item{pal}{The colour palette. If the vector supplied is less than n,
\code{grDevices::colorRampPalette()} will be used}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail values in the plot}

\item{showPwf}{Show the PASS/WARN/FAIL status}

\item{scaleFill, scaleColour}{ggplot2 scales to be used for colour palettes}

\item{heatCol}{Colour palette used for the heatmap. Default is \code{inferno}
from the viridis set of palettes}

\item{heat_w}{Relative width of any heatmap plot components}

\item{module}{The module to obtain data from when using a FastpData object}

\item{reads}{Either read1 or read2. Only used when using a FastpData object}

\item{readsBy}{Strategy for visualising both read1 and read2. Can be set to
show each set of reads by facet, or within the same plot taking the mean of
the enrichment above mean, or the difference in the enrichment above mean}

\item{trans}{Function for transforming the count/mean ratio. Set as NULL
to use the ratio without transformation}

\item{plotTheme}{\link[ggplot2]{theme} object}
}
\value{
A standard ggplot2 object or an interactive plotly object
}
\description{
Plot Overrepresented Kmers
}
\details{
As the Kmer Content module present in FastQC reports is relatively
uninformative, and omitted by default in later versions of FastQC, these
are rudimentary plots.

Plots for \code{FastqcData} objects replicate those contained in a FastQC
report, whilst the heatmap generated from \code{FastqcDataList} objects
simply show the location and abundance of over-represented Kmers.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)
plotKmers(fdl[[1]])

# Use a FastpData object
fl <- system.file("extdata", "fastp.json.gz", package = "ngsReports")
fp <- FastpData(fl)
plotKmers(fp, size = 2)
plotKmers(
  fp, reads = "read1", size = 2, trans = NULL,
  scaleFill = scale_fill_gradient(low = "white", high = "black")
)

}
