% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSeqQuals.R
\docType{methods}
\name{plotSeqQuals}
\alias{plotSeqQuals}
\alias{plotSeqQuals,ANY-method}
\alias{plotSeqQuals,character-method}
\alias{plotSeqQuals,FastqcData-method}
\alias{plotSeqQuals,FastqcDataList-method}
\title{Plot the Per Sequence Quality Scores}
\usage{
plotSeqQuals(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  ...
)

\S4method{plotSeqQuals}{ANY}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  ...
)

\S4method{plotSeqQuals}{character}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  ...
)

\S4method{plotSeqQuals}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  showPwf = TRUE,
  counts = FALSE,
  alpha = 0.1,
  warn = 30,
  fail = 20,
  colour = "red",
  plotlyLegend = FALSE,
  ...
)

\S4method{plotSeqQuals}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  counts = FALSE,
  alpha = 0.1,
  warn = 30,
  fail = 20,
  showPwf = TRUE,
  plotType = c("heatmap", "line"),
  dendrogram = FALSE,
  cluster = FALSE,
  scaleFill = NULL,
  heatCols = hcl.colors(100, "inferno"),
  heat_w = 8,
  scaleColour = NULL,
  plotlyLegend = FALSE,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or path}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.
All file names must be present in the names of the vector.}

\item{pattern}{Regex to remove from the end of any filenames}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} containing the colours
for PASS/WARN/FAIL}

\item{...}{Used to pass various potting parameters to theme.
Can also be used to set size and colour for box outlines.}

\item{showPwf}{logical(1) Show PASS/WARN/FAIL status}

\item{counts}{\code{logical}. Plot the counts from each file if
\code{counts = TRUE}, otherwise the frequencies will be plotted}

\item{alpha}{set alpha for line graph bounds}

\item{warn, fail}{The default values for warn and fail are 5 and 10
respectively (i.e. percentages)}

\item{colour}{Colour for single line plots}

\item{plotlyLegend}{logical(1) Show legend for interactive line plots}

\item{plotType}{\code{character}. Can only take the values
\code{plotType = "heatmap"} or \code{plotType = "line"}}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{scaleFill, scaleColour}{ggplot2 scales}

\item{heatCols}{Colour palette for the heatmap}

\item{heat_w}{Relative width of any heatmap plot components}
}
\value{
A standard ggplot2 object, or an interactive plotly object
}
\description{
Plot the Per Sequence Quality Scores for a set of FASTQC reports
}
\details{
Plots the distribution of average sequence quality scores across the
set of files. Values can be plotted either as counts (\code{counts = TRUE})
or as frequencies (\code{counts = FALSE}).

Any faceting or scale adjustment can be performed after generation of the
initial plot, using the standard methods of ggplot2 as desired.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# The default plot
plotSeqQuals(fdl)

# Also subset the reads to just the R1 files
r1 <- grepl("R1", fqName(fdl))
plotSeqQuals(fdl[r1])

}
