% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDupLevels.R
\docType{methods}
\name{plotDupLevels}
\alias{plotDupLevels}
\alias{plotDupLevels,ANY-method}
\alias{plotDupLevels,FastqcData-method}
\alias{plotDupLevels,FastqcDataList-method}
\alias{plotDupLevels,FastpData-method}
\alias{plotDupLevels,FastpDataList-method}
\title{Plot the combined Sequence_Duplication_Levels information}
\usage{
plotDupLevels(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotDupLevels}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotDupLevels}{FastqcData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 20,
  fail = 50,
  showPwf = TRUE,
  plotlyLegend = FALSE,
  lineCol = c("red", "blue"),
  lineWidth = 1,
  ...
)

\S4method{plotDupLevels}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 20,
  fail = 50,
  showPwf = TRUE,
  plotlyLegend = FALSE,
  deduplication = c("pre", "post"),
  plotType = c("heatmap", "line"),
  cluster = FALSE,
  dendrogram = FALSE,
  heatCol = hcl.colors(50, "inferno"),
  heat_w = 8,
  ...
)

\S4method{plotDupLevels}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 20,
  fail = 50,
  showPwf = FALSE,
  maxLevel = 10,
  lineCol = "red",
  barFill = "dodgerblue4",
  barCol = barFill,
  plotlyLegend = FALSE,
  plotTheme = theme_get(),
  ...
)

\S4method{plotDupLevels}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  pwfCols,
  warn = 20,
  fail = 50,
  showPwf = FALSE,
  plotlyLegend = FALSE,
  plotType = c("bar", "heatmap"),
  barFill = "blue",
  barCol = "blue",
  cluster = FALSE,
  dendrogram = FALSE,
  scaleFill = NULL,
  plotTheme = theme_get(),
  heat_w = 8,
  maxLevel = 10,
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file path}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.
File extensions are dropped by default.}

\item{pattern}{regex to remove from the end of fastp & fastq file names}

\item{...}{Used to pass additional attributes to theme() and between methods}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} to give colours for
pass, warning, and fail values in the plot}

\item{warn, fail}{The default values for warn and fail are 20 and 50
respectively (i.e. percentages)}

\item{showPwf}{logical(1) Show PWF rectangles in the background}

\item{plotlyLegend}{logical(1) Show legend for line plots when using
interactive plots}

\item{lineCol, lineWidth}{Colours and width of lines drawn}

\item{deduplication}{Plot Duplication levels 'pre' or 'post' deduplication.
Can only take values "pre" and "post"}

\item{plotType}{Choose between "heatmap" and "line"}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} Plot will automatically be clustered if TRUE.}

\item{heatCol}{Colour palette used for the heatmap}

\item{heat_w}{Relative width of the heatmap relative to other plot components}

\item{maxLevel}{The maximum duplication level to plot. Beyond this level, all
values will be summed}

\item{barFill, barCol}{Colours for bars when calling geom_col()}

\item{plotTheme}{\link[ggplot2]{theme} object. Applied after a call to
theme_bw()}

\item{scaleFill}{Discrete scale used to fill heatmap cells}
}
\value{
A standard ggplot2 or plotly object
}
\description{
Plot the Sequence_Duplication_Levels information for a set of
FASTQC reports
}
\details{
This extracts the Sequence_Duplication_Levels from the supplied object and
generates a ggplot2 object, with a set of minimal defaults. For multiple
reports, this defaults to a heatmap with block sizes proportional to the
percentage of reads belonging to that duplication category.

If setting \code{usePlotly = FALSE}, the output of this function can be
further modified using standard ggplot2 syntax. If setting
\code{usePlotly = TRUE} an interactive plotly object will be produced.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Draw the default plot for a single file
plotDupLevels(fdl[[1]])

plotDupLevels(fdl)

}
