% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAssemblyStats.R
\name{plotAssemblyStats}
\alias{plotAssemblyStats}
\title{Plot a summary of assembly logs}
\usage{
plotAssemblyStats(
  x,
  type = c("quast", "busco"),
  usePlotly = FALSE,
  plotType = c("bar", "paracoord"),
  ...
)
}
\arguments{
\item{x}{Paths to one or more log files}

\item{type}{The tool used. Can be one of quast or busco}

\item{usePlotly}{logical. If TRUE an interactive plot will be generated.
If FALSE a ggplot object will be output}

\item{plotType}{\code{character}. Plot type to output, one of bar or
paracoord.}

\item{...}{Used to pass additional attributes to theme() and between methods}
}
\value{
A ggplot2 object, or a plotly object
}
\description{
Plot a summary of assembly stats from a set of log files
}
\details{
Loads a set of assembly log files and creates a default plot.
Implemented tools are \code{quast} and \code{BUSCO}.
quast will plot a parralel coordinate plot of some assembly statistics
BUSCO will plot a stacked barplot of completeness statistics
}
\examples{

#getquast log filenames
quastFiles <- system.file("extdata",
c("quast1.tsv", "quast2.tsv"), package = "ngsReports")

# The default plot
plotAssemblyStats(quastFiles)

}
