% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path}
\alias{path}
\alias{path,.FastqcFile-method}
\alias{path,FastqcData-method}
\alias{path,FastqcDataList-method}
\alias{path,.FastpFile-method}
\alias{path,FastpData-method}
\alias{path,FastpDataList-method}
\title{Return the File Paths from an object}
\usage{
\S4method{path}{.FastqcFile}(object)

\S4method{path}{FastqcData}(object)

\S4method{path}{FastqcDataList}(object)

\S4method{path}{.FastpFile}(object)

\S4method{path}{FastpData}(object)

\S4method{path}{FastpDataList}(object)
}
\arguments{
\item{object}{An object of class .FastqcFile}
}
\value{
A character vector of the file paths to the underlying FastQC reports
}
\description{
Return the File Paths from an object
}
\details{
Obtains the file.path for objects of multiple classes
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)
path(fdl)

}
