% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModule.R
\docType{methods}
\name{getModule,FastqcData-method}
\alias{getModule,FastqcData-method}
\alias{getModule}
\alias{getModule,FastqcDataList-method}
\alias{getModule,ANY-method}
\alias{getModule,FastpData-method}
\alias{getModule,FastpDataList-method}
\title{Retrieve a given module from a Fastqc* Object}
\usage{
\S4method{getModule}{FastqcData}(object, module)

\S4method{getModule}{FastqcDataList}(object, module)

\S4method{getModule}{ANY}(object, module)

\S4method{getModule}{FastpData}(object, module)

\S4method{getModule}{FastpDataList}(object, module)
}
\arguments{
\item{object}{Can be a \code{FastqcData}, \code{fastqcDataList}, or simply
a \code{character} vector of paths}

\item{module}{The requested module as contained in a FastQC report. Possible
values are \code{Summary}, \code{Basic_Statistics},
\code{Per_base_sequence_quality}, \code{Per_tile_sequence_quality},
\code{Per_sequence_quality_scores}, \code{Per_base_sequence_content},
\code{Per_sequence_GC_content}, \code{Per_base_N_content},
\code{Sequence_Length_Distribution}, \code{Sequence_Duplication_Levels},
\code{Overrepresented_sequences}, \code{Adapter_Content},
\code{Kmer_Content}, \code{Total_Deduplicated_Percentage}.
Note that spelling and capitalisation is exactly as contained within a
FastQC report, with the exception that spaces have been converted to
underscores. Partial matching is implemented for this argument.}
}
\value{
A single \code{tibble} containing module-level information
from all FastQC reports contained in the Fastqc* object.
}
\description{
Retrieve a specific module from a Fastqc* object as a
data.frame
}
\details{
This function will return a given module from a Fastqc* object as a
data.frame. Note that each module will be it's own unique structure,
although all will return a data.frame
}
\examples{
# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Extract the Summary module, which corresponds to the PASS/WARN/FAIL flags
getModule(fdl, "Summary")

# The Basic_Statistics module corresponds to the table at the top of each
# FastQC report
getModule(fdl, "Basic_Statistics")

}
