% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqcVersion.R
\docType{methods}
\name{fqcVersion,FastqcData-method}
\alias{fqcVersion,FastqcData-method}
\alias{fqcVersion}
\alias{fqcVersion,FastqcDataList-method}
\alias{fqcVersion,ANY-method}
\title{Get the FASTQC version}
\usage{
\S4method{fqcVersion}{FastqcData}(object)

\S4method{fqcVersion}{FastqcDataList}(object)

\S4method{fqcVersion}{ANY}(object)
}
\arguments{
\item{object}{An object of class \code{FastqcData} or \code{FastqcDataList}}
}
\value{
A character vector (FastqcData), or tibble (FastqcDataList)
}
\description{
Get the FASTQC version used to generate the intial files
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Get the FASTQC version
fqcVersion(fdl)

}
