% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netsim.R
\name{sim_mix}
\alias{sim_mix}
\title{Simulate from mixture model.}
\usage{
sim_mix(n, n.comp, mix.prob, Mu, Sig, dist = "norm", df = 2)
}
\arguments{
\item{n}{sample size}

\item{n.comp}{number of mixture components ("comps")}

\item{mix.prob}{mixing probablities (need to sum to 1)}

\item{Mu}{matrix of component-specific mean vectors}

\item{Sig}{array of component-specific covariance matrices}

\item{dist}{'norm' for Gaussian components, 't' for t-distributed components}

\item{df}{degrees of freedom of the t-distribution (not used for Gaussian 
distribution), default=2}
}
\value{
a list consisting of:
\item{S}{component assignments}
\item{X}{observed data matrix}
}
\description{
Simulate from mixture model with multi-variate Gaussian or t-distributed 
components.
}
\examples{
n.comp = 4
p = 5 # dimensionality
Mu = matrix(rep(0, p), p, n.comp)
Sigma = array(diag(p), c(p, p, n.comp))
mix.prob = rep(0.25, n.comp)

sim_mix(100, n.comp, mix.prob, Mu, Sigma)
}
\author{
n.stadler
}
