% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet.R
\name{screen_bic.glasso}
\alias{screen_bic.glasso}
\title{BIC-tuned glasso with additional thresholding}
\usage{
screen_bic.glasso(x, include.mean = TRUE, length.lambda = 20,
  lambdamin.ratio = ifelse(ncol(x) > nrow(x), 0.01, 0.001),
  penalize.diagonal = FALSE, plot.it = FALSE,
  trunc.method = "linear.growth", trunc.k = 5, use.package = "huge",
  verbose = FALSE)
}
\arguments{
\item{x}{The input data. Needs to be a num.samples by dim.samples matrix.}

\item{include.mean}{Include mean in likelihood. TRUE / FALSE (default).}

\item{length.lambda}{Length of lambda path to consider (default=20).}

\item{lambdamin.ratio}{Ratio lambda.min/lambda.max.}

\item{penalize.diagonal}{If TRUE apply penalization to diagonal of inverse
covariance as well. (default=FALSE)}

\item{plot.it}{TRUE / FALSE (default)}

\item{trunc.method}{None / linear.growth (default) / sqrt.growth}

\item{trunc.k}{truncation constant, number of samples per predictor (default=5)}

\item{use.package}{'glasso' or 'huge' (default).}

\item{verbose}{If TRUE, output la.min, la.max and la.opt (default=FALSE).}
}
\value{
Returns a list with named elements 'rho.opt', 'wi', 'wi.orig', 
         Variable rho.opt is the optimal (scaled) penalization parameter (rho.opt=2*la.opt/n). 
         The variables wi and wi.orig are matrices of size dim.samples by dim.samples 
         containing the truncated and untruncated inverse covariance matrix.
}
\description{
BIC-tuned glasso with additional thresholding
}
\examples{
n=50
p=5
x=matrix(rnorm(n*p),n,p)
wihat=screen_bic.glasso(x,length.lambda=5)$wi
}
\author{
n.stadler
}
