/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i HierarchicalClustering_main.ggo -F HierarchicalClustering_main.cmdline 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "HierarchicalClustering_main.cmdline.h"

const char *gengetopt_args_info_purpose = "MC-UPGMA - Accurate huge scale clustering by Memory Constrained UPGMA. Provide\npart of the complete accurate hierarchical clustering solution (tree), by\nreading only part of the edges into memory as dictated by an explicit memory\nconstraint M. The input is a sparse graph of non-negative cluster distances, or\ndissimilarities, as scores are allowed to be non-metric. In the first run,\ndissimilarities between single data items (singleton clusters) are given.\nMissing edges in the sparse graph are assumed to be equal \\psi (the\nmax-distance command line argument) for the purpose of computing average\ncluster distances. Average cluster dissimilarities are required as input to\ncontinue clustering, and are computed by external programs to this program.\n\nIf you find this code useful, please cite:\nLoewenstein Y, Portugaly E, Fromer M, Linial M.\nEfficient algorithms for accurate hierarchical clustering of huge datasets:\ntackling the entire protein space.\nBioinformatics. 2008 Jul 1;24(13):i41-9.\n";

const char *gengetopt_args_info_usage = "Usage: hierarchical_clustering (MC-UPGMA) [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -d, --max-distance=FLOAT      Max possible distance between two singletons\n                                  (\\psi). Used for missing edges when\n                                  averaging across clusters. ",
  "  -n, --max-cluster-index=INT   Index of the last singleton (may be more than\n                                  that)",
  "  -M, --number-of-input-edges=INT\n                                Memory constraint - maximum number of edges to\n                                  load from input",
  "  -a, --average-type=STRING     {arithmetic, geometric, minimum, maximum} - the\n                                  clustering objective (e.g. average-linkage,\n                                  complete-linkage etc.).\n                                  (default=`arithmetic')",
  "  -i, --input-cluster-edges-file=STRING\n                                Cluster (or singleton) edges (format: cluster1\n                                  cluster2 distance)  (default=`-')",
  "  -o, --output-merges-file-name=STRING\n                                Output merges file  (default=`-')",
  "      --input-cluster-sizes-file-name=STRING\n                                Initial size of each input cluster (singleton\n                                  size)",
  "      --output-cluster-sizes-file-name=STRING\n                                End size of each output cluster (cluster size)",
  "      --allow-non-dendrogram    Allows merging of provably minimal edge\n                                  intervals, even if the exact merge score\n                                  (cluster height in dendrogram) is not known\n                                  at merge time due to partial knowledge\n                                  implied by the memory constraint. This option\n                                  allows further clustering per round, thus\n                                  speeding up the wholse clustering process\n                                  considerably, by posing a less strict\n                                  requirement on the output - now the cluster\n                                  heights are no longer required to be exact.\n                                  Currently, an upper bound on the merge score\n                                  is output in this case.  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->max_distance_given = 0 ;
  args_info->max_cluster_index_given = 0 ;
  args_info->number_of_input_edges_given = 0 ;
  args_info->average_type_given = 0 ;
  args_info->input_cluster_edges_file_given = 0 ;
  args_info->output_merges_file_name_given = 0 ;
  args_info->input_cluster_sizes_file_name_given = 0 ;
  args_info->output_cluster_sizes_file_name_given = 0 ;
  args_info->allow_non_dendrogram_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->max_distance_orig = NULL;
  args_info->max_cluster_index_orig = NULL;
  args_info->number_of_input_edges_orig = NULL;
  args_info->average_type_arg = gengetopt_strdup ("arithmetic");
  args_info->average_type_orig = NULL;
  args_info->input_cluster_edges_file_arg = gengetopt_strdup ("-");
  args_info->input_cluster_edges_file_orig = NULL;
  args_info->output_merges_file_name_arg = gengetopt_strdup ("-");
  args_info->output_merges_file_name_orig = NULL;
  args_info->input_cluster_sizes_file_name_arg = NULL;
  args_info->input_cluster_sizes_file_name_orig = NULL;
  args_info->output_cluster_sizes_file_name_arg = NULL;
  args_info->output_cluster_sizes_file_name_orig = NULL;
  args_info->allow_non_dendrogram_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->max_distance_help = gengetopt_args_info_help[2] ;
  args_info->max_cluster_index_help = gengetopt_args_info_help[3] ;
  args_info->number_of_input_edges_help = gengetopt_args_info_help[4] ;
  args_info->average_type_help = gengetopt_args_info_help[5] ;
  args_info->input_cluster_edges_file_help = gengetopt_args_info_help[6] ;
  args_info->output_merges_file_name_help = gengetopt_args_info_help[7] ;
  args_info->input_cluster_sizes_file_name_help = gengetopt_args_info_help[8] ;
  args_info->output_cluster_sizes_file_name_help = gengetopt_args_info_help[9] ;
  args_info->allow_non_dendrogram_help = gengetopt_args_info_help[10] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->max_distance_orig));
  free_string_field (&(args_info->max_cluster_index_orig));
  free_string_field (&(args_info->number_of_input_edges_orig));
  free_string_field (&(args_info->average_type_arg));
  free_string_field (&(args_info->average_type_orig));
  free_string_field (&(args_info->input_cluster_edges_file_arg));
  free_string_field (&(args_info->input_cluster_edges_file_orig));
  free_string_field (&(args_info->output_merges_file_name_arg));
  free_string_field (&(args_info->output_merges_file_name_orig));
  free_string_field (&(args_info->input_cluster_sizes_file_name_arg));
  free_string_field (&(args_info->input_cluster_sizes_file_name_orig));
  free_string_field (&(args_info->output_cluster_sizes_file_name_arg));
  free_string_field (&(args_info->output_cluster_sizes_file_name_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->max_distance_given)
    write_into_file(outfile, "max-distance", args_info->max_distance_orig, 0);
  if (args_info->max_cluster_index_given)
    write_into_file(outfile, "max-cluster-index", args_info->max_cluster_index_orig, 0);
  if (args_info->number_of_input_edges_given)
    write_into_file(outfile, "number-of-input-edges", args_info->number_of_input_edges_orig, 0);
  if (args_info->average_type_given)
    write_into_file(outfile, "average-type", args_info->average_type_orig, 0);
  if (args_info->input_cluster_edges_file_given)
    write_into_file(outfile, "input-cluster-edges-file", args_info->input_cluster_edges_file_orig, 0);
  if (args_info->output_merges_file_name_given)
    write_into_file(outfile, "output-merges-file-name", args_info->output_merges_file_name_orig, 0);
  if (args_info->input_cluster_sizes_file_name_given)
    write_into_file(outfile, "input-cluster-sizes-file-name", args_info->input_cluster_sizes_file_name_orig, 0);
  if (args_info->output_cluster_sizes_file_name_given)
    write_into_file(outfile, "output-cluster-sizes-file-name", args_info->output_cluster_sizes_file_name_orig, 0);
  if (args_info->allow_non_dendrogram_given)
    write_into_file(outfile, "allow-non-dendrogram", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->max_distance_given)
    {
      fprintf (stderr, "%s: '--max-distance' ('-d') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->max_cluster_index_given)
    {
      fprintf (stderr, "%s: '--max-cluster-index' ('-n') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->number_of_input_edges_given)
    {
      fprintf (stderr, "%s: '--number-of-input-edges' ('-M') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "max-distance",	1, NULL, 'd' },
        { "max-cluster-index",	1, NULL, 'n' },
        { "number-of-input-edges",	1, NULL, 'M' },
        { "average-type",	1, NULL, 'a' },
        { "input-cluster-edges-file",	1, NULL, 'i' },
        { "output-merges-file-name",	1, NULL, 'o' },
        { "input-cluster-sizes-file-name",	1, NULL, 0 },
        { "output-cluster-sizes-file-name",	1, NULL, 0 },
        { "allow-non-dendrogram",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVd:n:M:a:i:o:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'd':	/* Max possible distance between two singletons (\\psi). Used for missing edges when averaging across clusters. .  */
        
        
          if (update_arg( (void *)&(args_info->max_distance_arg), 
               &(args_info->max_distance_orig), &(args_info->max_distance_given),
              &(local_args_info.max_distance_given), optarg, 0, 0, ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "max-distance", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Index of the last singleton (may be more than that).  */
        
        
          if (update_arg( (void *)&(args_info->max_cluster_index_arg), 
               &(args_info->max_cluster_index_orig), &(args_info->max_cluster_index_given),
              &(local_args_info.max_cluster_index_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "max-cluster-index", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Memory constraint - maximum number of edges to load from input.  */
        
        
          if (update_arg( (void *)&(args_info->number_of_input_edges_arg), 
               &(args_info->number_of_input_edges_orig), &(args_info->number_of_input_edges_given),
              &(local_args_info.number_of_input_edges_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "number-of-input-edges", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* {arithmetic, geometric, minimum, maximum} - the clustering objective (e.g. average-linkage, complete-linkage etc.)..  */
        
        
          if (update_arg( (void *)&(args_info->average_type_arg), 
               &(args_info->average_type_orig), &(args_info->average_type_given),
              &(local_args_info.average_type_given), optarg, 0, "arithmetic", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "average-type", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Cluster (or singleton) edges (format: cluster1 cluster2 distance).  */
        
        
          if (update_arg( (void *)&(args_info->input_cluster_edges_file_arg), 
               &(args_info->input_cluster_edges_file_orig), &(args_info->input_cluster_edges_file_given),
              &(local_args_info.input_cluster_edges_file_given), optarg, 0, "-", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "input-cluster-edges-file", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output merges file.  */
        
        
          if (update_arg( (void *)&(args_info->output_merges_file_name_arg), 
               &(args_info->output_merges_file_name_orig), &(args_info->output_merges_file_name_given),
              &(local_args_info.output_merges_file_name_given), optarg, 0, "-", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-merges-file-name", 'o',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Initial size of each input cluster (singleton size).  */
          if (strcmp (long_options[option_index].name, "input-cluster-sizes-file-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->input_cluster_sizes_file_name_arg), 
                 &(args_info->input_cluster_sizes_file_name_orig), &(args_info->input_cluster_sizes_file_name_given),
                &(local_args_info.input_cluster_sizes_file_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "input-cluster-sizes-file-name", '-',
                additional_error))
              goto failure;
          
          }
          /* End size of each output cluster (cluster size).  */
          else if (strcmp (long_options[option_index].name, "output-cluster-sizes-file-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_cluster_sizes_file_name_arg), 
                 &(args_info->output_cluster_sizes_file_name_orig), &(args_info->output_cluster_sizes_file_name_given),
                &(local_args_info.output_cluster_sizes_file_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-cluster-sizes-file-name", '-',
                additional_error))
              goto failure;
          
          }
          /* Allows merging of provably minimal edge intervals, even if the exact merge score (cluster height in dendrogram) is not known at merge time due to partial knowledge implied by the memory constraint. This option allows further clustering per round, thus speeding up the wholse clustering process considerably, by posing a less strict requirement on the output - now the cluster heights are no longer required to be exact. Currently, an upper bound on the merge score is output in this case..  */
          else if (strcmp (long_options[option_index].name, "allow-non-dendrogram") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->allow_non_dendrogram_flag), 0, &(args_info->allow_non_dendrogram_given),
                &(local_args_info.allow_non_dendrogram_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "allow-non-dendrogram", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
