% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{pifit}
\alias{pifit}
\title{Accuracy computation}
\usage{
pifit(x, y, D, unknown = "", balanced = FALSE, propagate = TRUE, knowns = NULL)
}
\arguments{
\item{x}{object of class nempi}

\item{y}{object of class mnemsim}

\item{D}{data matrix}

\item{unknown}{label for the unlabelled samples}

\item{balanced}{if TRUE, computes balanced accuracy}

\item{propagate}{if TRUE, propagates the perturbation through the network}

\item{knowns}{subset of P-genes that are known to be
perturbed (the other are neglegted)}
}
\value{
list of different accuracy measures: true/false positives/negatives,
correlation, area under the precision recall curve, (balanced) accuracy
}
\description{
Compares the ground truth of a perturbation profile with
the inferred profile
}
\examples{
library(mnem)
seed <- 42
Pgenes <- 10
Egenes <- 10
samples <- 100
uninform <- floor((Pgenes*Egenes)*0.1)
Nems <- mw <- 1
noise <- 1
multi <- c(0.2, 0.1)
set.seed(seed)
simmini <- simData(Sgenes = Pgenes, Egenes = Egenes,
Nems = Nems, mw = mw, nCells = samples,
uninform = uninform, multi = multi,
badCells = floor(samples*0.1))
data <- simmini$data
ones <- which(data == 1)
zeros <- which(data == 0)
data[ones] <- rnorm(length(ones), 1, noise)
data[zeros] <- rnorm(length(zeros), -1, noise)
lost <- sample(1:ncol(data), floor(ncol(data)*0.5))
colnames(data)[lost] <- ""
res <- nempi(data)
fit <- pifit(res, simmini, data)
}
\author{
Martin Pirkl
}
