% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{classpi}
\alias{classpi}
\title{Classification}
\usage{
classpi(
  D,
  unknown = "",
  full = TRUE,
  method = "svm",
  size = NULL,
  MaxNWts = 10000,
  ...
)
}
\arguments{
\item{D}{either a binary effects matrix or log odds matrix as
for Nested Effects Models (see package 'nem')}

\item{unknown}{colname of samples without mutation data, E.g. ""}

\item{full}{if FALSE, does not change the known profiles}

\item{method}{either one of svm, nn, rf}

\item{size}{parameter for neural network (see package 'nnet')}

\item{MaxNWts}{parameters for neural network (see package 'nnet')}

\item{...}{additional parameters for mnem::nem}
}
\value{
plot
}
\description{
Builds and uses different classifiers to infer perturbation profiles
}
\examples{
D <- matrix(rnorm(1000*100), 1000, 100)
colnames(D) <- sample(seq_len(5), 100, replace = TRUE)
Gamma <- matrix(sample(c(0,1), 5*100, replace = TRUE, p = c(0.9, 0.1)), 5,
100)
Gamma <- apply(Gamma, 2, function(x) return(x/sum(x)))
Gamma[is.na(Gamma)] <- 0
rownames(Gamma) <- seq_len(5)
result <- classpi(D)
}
\author{
Martin Pirkl
}
