% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanBAMtoBG.R
\name{CleanBAMtoBG}
\alias{CleanBAMtoBG}
\title{CleanBAMtoBG}
\usage{
CleanBAMtoBG(in_bam, out_bedGraph = NA, unwanted_chromosomes = NULL)
}
\arguments{
\item{in_bam}{Name of sorted BAM file to be converted to a bedGraph file.
Required.}

\item{out_bedGraph}{Name of bedGraph output file, including full directory
path. Default in_bam prefix.}

\item{unwanted_chromosomes}{A vector of unwanted chromosomes that are present
in the BAM file.}
}
\value{
deposits bedGraph from BAM in same directory
}
\description{
Writes a script to convert a BAM file to a clean bedGraph file.
}
\examples{
bam <- system.file("extdata/chr4and5.bam", package="nearBynding")
#sort BAM first
sorted_bam<-Rsamtools::sortBam(bam, "chr4and5_sorted")
CleanBAMtoBG(in_bam = sorted_bam)

\donttest{
    ## If BAM has unwanted chromosome "EBV"
    ## this file is from ENCODE database
    CleanBAMtoBG(in_bam = "ENCFF288LEG.bam",
                 unwanted_chromosomes = "EBV")
}

}
