% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzIDevidence.R
\docType{class}
\name{mzIDevidence-class}
\alias{evidence,mzIDevidence-method}
\alias{length,mzIDevidence-method}
\alias{mzIDevidence-class}
\alias{show,mzIDevidence-method}
\title{A class to store peptide evidence information from an mzIdentML file}
\usage{
\S4method{show}{mzIDevidence}(object)

\S4method{length}{mzIDevidence}(x)

\S4method{evidence}{mzIDevidence}(object, safeNames = TRUE)
}
\arguments{
\item{object}{An mzIDevidence object}

\item{x}{An mzIDevidence object}

\item{safeNames}{Should column names be lowercased to ensure compatibility
between v1.0 and v1.1 files?}
}
\description{
This class handles parsing and storage of peptide evidence information from 
mzIDentML files, residing at the /*/x:SequenceCollection/x:PeptideEvidence 
node.
}
\details{
The content of the class is stored in a data.frame with columns depending on 
the content of the mzIdentML file. Columns represent the attribute values of 
for each PeptideEvidence node. For files conforming to the HUPO standard, 
dbSequence_ref, id and peptide_ref is required while start, end, pre, post, 
name, isDecoy, frame and translationTable_ref are optional. Information 
residing in cvParam and userParam children are not parsed.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Short summary of the content of the object

\item \code{length}: Report number of evidence

\item \code{evidence}: Get the evidence from the peptide search
}}
\section{Slots}{

\describe{
\item{\code{evidence}}{A data.frame containing all peptide evidence from the 
mzIdentML file}
}}
\section{Objects from the class}{

Objects of mzIDevidence are not meant to be created explicitly but as part of
the \code{\link{mzID-class}}. Still object can be created with the 
constructor \code{\link{mzIDevidence}}.
}
\seealso{
\code{\link{mzIDevidence}}

Other mzID.classes: \code{\link{mzID-class}},
  \code{\link{mzIDCollection-class}},
  \code{\link{mzIDdatabase-class}},
  \code{\link{mzIDparameters-class}},
  \code{\link{mzIDpeptides-class}},
  \code{\link{mzIDpsm-class}}
}

