% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{umap}
\alias{umap}
\alias{umap,musica-method}
\alias{umap,result_collection-method}
\alias{umap,result_model-method}
\alias{umap<-}
\alias{umap<-,musica,matrix-method}
\alias{umap<-,result_collection,matrix-method}
\alias{umap<-,result_model,matrix-method}
\title{Retrieve umap list from a result_model, result_collection, or musica
object}
\usage{
umap(x, ...)

\S4method{umap}{musica}(x, result, modality, model_id)

\S4method{umap}{result_collection}(x, modality, model_id)

\S4method{umap}{result_model}(x)

umap(x, ...) <- value

\S4method{umap}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{umap}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{umap}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the
umap. Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the umap. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the umap. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{A list of umap dataframes}
}
\value{
A list of umap dataframes
}
\description{
The umap dataframes for the model
}
\examples{
data(res)
umap(res, "result", "SBS96", "res")
}
