% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sample_reconstruction_error.R
\name{plot_sample_reconstruction_error}
\alias{plot_sample_reconstruction_error}
\title{Plot reconstruction error for a sample}
\usage{
plot_sample_reconstruction_error(
  musica,
  sample,
  model_id,
  modality = "SBS96",
  result_name = "result",
  plotly = FALSE
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{sample}{Name of the sample within the \code{\linkS4class{musica}}
object.}

\item{model_id}{The name of the desired model.}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78",
or "IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing desired model.
Default \code{"result"}.}

\item{plotly}{If \code{TRUE}, the the plot will be made interactive
using \code{\link[plotly]{plotly}}. Default \code{FALSE}.}
}
\value{
Generates a ggplot or plotly object
}
\description{
Displays the observed distribution of counts for each mutation type,
the distribution of reconstructed counts for each mutation type using
the inferred mutational signatures, and the difference between the
two distributions.
}
\examples{
data(res)
plot_sample_reconstruction_error(res, "TCGA-ER-A197-06A-32D-A197-08",
model_id = "res")
}
